#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
# pkgdeps: import LauncherContext

# pkgdeps: rpmwith %{_libdir}/SysdbMountProfiles/LauncherOpenConfig
from OpenConfigLauncherLib import openConfigRunnability

def Plugin( context ):
   # Note: AleVirtualL3Unicast RPM has only been added to the ceoslab image
   # Any non-ceoslab image will not have AleVirtualL3Unicast Agent running despite
   # open config is running
   agentName = 'AleVirtualL3Unicast'

   # Do not run this agent if Sfe is running. This happens on cEOS-cloudlab
   # containers which are based on cEOS-lab, but with a different dataplane
   # The Sfe agent is the forwarding agent on these duts
   sfeLauncherPath = 'hardware/sfe/launcherConfig/Sfe'
   sfeNotPresent = ( { 'qualPath': sfeLauncherPath,
                      'negate': True } )
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/AleVirtualL3Unicast',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': ( sfeNotPresent, openConfigRunnability( context ) ),
               }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
