#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # ArpWatcher's functionality is provided by the Arp agent whose agent
   # configuration is described by the LauncherPlugin for Ira

   def configureAgent( agentName, exe ):
      agentCfg = { "name": agentName,
                   "exe": exe,
                   "argv": [],
                   "heartbeatPeriod": 30 }
      context.agentConfigIs( roleName, agentCfg )

   roleName = { 'sso' : context.allSupervisorsRoleName,
                'rpr' : context.activeSupervisorRoleName }
   configureAgent( "Arp", "/usr/bin/Arp" )
