# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

# TODO: Remove dependency once there is an explicit dependency on Sfe-lib rpm
# pkgdeps: import LauncherPlugin.Sfe
# pkgdeps: import McastCommonAgent

def Plugin( context ):
   bessConfig = context.lookup( 'bess/agentstatus/cli' )
   bessStatus = context.lookup( 'routing/multicast/agent/status/BessMgr' )

   runnability = [ {
      'entity' : bessConfig,
      'qualAttr' : 'v4Enabled'
   }, {
      'entity' : bessConfig,
      'qualAttr' : 'v6Enabled'
   }, {
      'entity' : bessStatus,
      'qualAttr' : 'running'
   } ]

   agentCfg = {
      "name" : "BessMgr",
      "exe" : "/usr/bin/BessMgr",
      "argv" : [],
      "heartbeatPeriod" : 30,
      "runnability" : runnability
   }

   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )
