#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

import Toggles.BfdToggleLib

def Plugin( context ):
   if Toggles.BfdToggleLib.toggleBfdConditionallyRunnableEnabled():
      qp1 = "cell/%cellId/bfd/activeAgent/bfd"
      qp2 = "bfd/launcherControl/%*"
      bfdLauncherControl = { 'qualPath': qp2, 'readableText':
                              'The number of BFD requests is greater than 0' }
      bfdActiveAgent = { 'qualPath': qp1, 'readableText':
                           'Bfd agent is active' }
      # The Cli command "show agent Bfd runnability" will provide the following
      # readable text explanation of if Bfd is running.
      agentCfg = { "name": "Bfd",
                  "exe": "/usr/bin/Bfd",
                  "argv": [],
                  "oomScoreAdj": -150, # see AID3426
                  "heartbeatPeriod": 63,
                  "runnability":
               [ bfdLauncherControl, bfdActiveAgent ],
               }
   else:
      agentCfg = { "name": "Bfd",
                  "exe": "/usr/bin/Bfd",
                  "argv": [],
                  "oomScoreAdj": -150, # see AID3426
                  "heartbeatPeriod": 63,
                  }

   roleName = { 'sso': context.allSupervisorsRoleName,
                'rpr': context.activeSupervisorRoleName }
   context.agentConfigIs( roleName, agentCfg )
