# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentCfg = {
      'name': 'BgpStream',
      'exe': '/usr/bin/BgpStream',
      'argv': [],
      'heartbeatPeriod': 120,
      'runnability': [ { 'entity': context.lookup( 'mgmt/octa/config' ),
                         'qualAttr': 'bgpRibIpv4Unicast' },
                       { 'entity': context.lookup( 'mgmt/octa/config' ),
                         'qualAttr': 'bgpRibIpv6Unicast' },
                       { 'entity': context.lookup( 'routing/bgpstream/status' ),
                         'qualAttr': 'isActive' } ]
   }
   context.agentConfigIs( context.activeSupervisorRoleName, agentCfg )
