#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   srteColorDscpConfig = context.lookup( "te/segmentrouting/cbf/color-dscp/config" )
   teColorDscpConfig = context.lookup( "te/cbf/color-dscp/config" )
   colorTcConfig = context.lookup( "te/cbf/color-tc/config" )
   colorVrfConfig = context.lookup( "te/cbf/color-vrf/config" )
   status = context.lookup( "te/cbf/status" )

   # This is an OR criteria between the Cbf config in any of the above three modes
   # If any one collection is non-empty, the Cbf agent will be started
   runnability = [ { "entity": srteColorDscpConfig, "qualAttr": "colorToValue" },
                   { "entity": teColorDscpConfig, "qualAttr": "colorToValue" },
                   { "entity": colorTcConfig, "qualAttr": "colorToValue" },
                   { "entity": colorVrfConfig, "qualAttr": "colorToValue" },
                   { "entity": status, "qualAttr": "active" } ]

   agentCfg = { "name": "Cbf",
                "exe": "/usr/bin/Cbf",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
