#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   cdpConfig = context.lookup( 'l2discovery/cdp/config' )
   roleName = context.activeSupervisorRoleName
   agentCfg = { "name": "Cdp",
                "exe": "/usr/bin/Cdp",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": [ { "entity": cdpConfig,
                                   "qualAttr": "intfNames" },
                                 { "entity": cdpConfig,
                                   "qualAttr": "lagNames" },
                                 { "entity": cdpConfig,
                                   "qualAttr": "rxEnabled" } ] }

   context.agentConfigIs( roleName, agentCfg )
