#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def Plugin( context ):
   config = context.lookup( 'clb/config' )
   requirements = context.lookup( 'clb/hardware/requirements' )
   capabilities = context.lookup( 'clb/hardware/capabilities' )
   roleName = context.activeSupervisorRoleName

   agentName = "Clb"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Clb",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": (
                   # the agent needs to know the hw offload method to initialize
                   { 'entity': capabilities,
                     'qualAttr': 'hwOffloadMethod' },
                   # both forwarding mode and flow source need to be enabled
                   [ ( { 'entity': config,
                         'qualAttr': 'forwardingMode' },
                       { 'entity': config,
                         'qualAttr': 'loadBalanceMethod' } ),
                     # this is required for the agent to be able to cleanup
                     # before being killed
                     { 'entity': requirements,
                       'qualAttr': 'forwardingMode' } ] )
                }
   context.agentConfigIs( roleName, agentCfg )
