# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
from Toggles.ConnectivityMonitorToggleLib import (
      toggleCMDynamicInputEnabled,
)

def Plugin( context ):

   config = context.lookup( 'connectivityMonitor/config' )
   status = context.lookup( 'connectivityMonitor/status' )
   agentRunnabilityLogMgr = []
   if toggleCMDynamicInputEnabled():
      logMgrConfig = context.lookup( 'connectivityMonitor/clientConfigDir/logMgr' )
      logMgrStatus = context.lookup( 'connectivityMonitor/clientStatusDir/logMgr' )
      # For LogMgr client, we should start if hostConfig/hostStatus is present.
      agentRunnabilityLogMgr = [ { 'entity': logMgrConfig,
                                   'qualAttr': 'hostConfig' },
                                 { 'entity': logMgrStatus,
                                   'qualAttr': 'hostStatus' } ]


   agentName = 'ConnectivityMonitor'
   # If enabled is true in config or status, the agent should start
   agentRunnabilityEnabled = [ { 'entity': config,
                                 'qualAttr': 'enabled' },
                               { 'entity': status,
                                 'qualAttr': 'enabled' } ]

   # Runnability depends on no shut of connectivity monitor and if config is created
   # dynamically from another agent.
   agentRunnability = agentRunnabilityEnabled + agentRunnabilityLogMgr

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/ConnectivityMonitor',
                'argv': [],
                'heartbeatPeriod': 30,
                "startupGracePeriod": 900,
                'runnability': agentRunnability,
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
