#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherContext

def Plugin( context ):
   containerMgrConfig = context.lookup( "containerMgr/config" )
   containerMgrSuperServerStatus = context.lookup( "containerMgr/superServerStatus" )
   runnability = [ { "entity": containerMgrConfig,
                     "qualAttr": "agentEnabled" },
                   { "entity": containerMgrSuperServerStatus,
                     "qualAttr": "enabled" } ]
   agentCfg = { "name": "ContainerMgr",
                "exe": "/usr/bin/ContainerMgr",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": runnability }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
