#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'mgmt/controller/config' )
   status = context.lookup( 'mgmt/controller/status' )

   agentName = 'ControllerClient'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/ControllerClient',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability' : [ { 'entity' : config, 'qualAttr' : "enabled" },
                                  { 'entity' : status, 'qualAttr' : "enabled" } ]
                }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
