# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

import Tac
import Toggles.FlowTrackerToggleLib

FtConfig = Tac.Type( 'FlowTracking::Config' )

def Plugin( context ):
   if not Toggles.FlowTrackerToggleLib.toggleCpuQueueFlowTrackingEnabled():
      return

   agentName = 'DmaMonitor'
   ftActiveAgentPath = f'flowtracking/activeAgent/{agentName}'
   ftHwCapabilities = context.lookup(
      'hardware/flowtracking/capabilities/cpuQueue' )
   ftConfig = context.lookup(
      FtConfig.cpuQueueFlowTrackingCliConfigPath() )

   runnability = [
      ( {
            # whether it's supported on this platform
            'entity': ftHwCapabilities,
            'qualAttr': 'supported',
        },
        {
            # if the feature is enabled
            'entity': ftConfig,
            'qualAttr': 'enabled',
        },
      ),
      {
         # if the agent is active and/or has dirty state
         'qualPath': ftActiveAgentPath,
      },
   ]

   agentConfig = {
      'name': agentName,
      'exe': '/usr/bin/DmaMonitor',
      'argv': [],
      'heartbeatPeriod': 30,
      'runnability': runnability,
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentConfig )
