# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   dmfCliConfig = context.lookup( 'dmf/cli/config' )
   dmfIndigoStatus = context.lookup( 'dmf/indigo/status' )
   ztnStatus = context.lookup( 'ztn/status' )

   runnability = [ ( { 'entity': dmfCliConfig, 'qualAttr': 'enabled' },
                     { 'entity': ztnStatus, 'qualAttr': 'handshakeComplete' } ),
                     { 'entity': dmfIndigoStatus, 'qualAttr': 'active' } ]

   agentCfg = {
      "name": "DmfIndigo",
      "exe": "/usr/bin/DmfIndigo",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability": runnability
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
