# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   dmfCliConfig = context.lookup( 'dmf/cli/config' )
   dmfPolicyStatus = context.lookup( 'dmf/policy/status' )
   runnability = [ { 'entity': dmfCliConfig, 'qualAttr': 'enabled' },
                   { 'entity': dmfPolicyStatus, 'qualAttr': 'active' } ]
   agentCfg = {
      "name": "DmfPolicy",
      "exe": "/usr/bin/DmfPolicy",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability": runnability
   }
   role = context.allSupervisorsRoleName
   context.agentConfigIs( role, agentCfg )
