#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def getRunnability( context, pllName ):
   pllConfigPath = f'hardware/pllClockMux/config/{pllName}'

   entity = context.lookup
   ptpConfig = entity( 'ptp/config' )
   timestampFeatureStatus = context.lookup( 'ptpTimeSync/featureStatus' )

   anyPlls = { 'qualPath': f'{pllConfigPath}.pllCfg/%*' }
   anyDefaultPlls = { 'qualPath': f'{pllConfigPath}.defaultPll/%*' }
   ptpEnabled = { 'entity': ptpConfig, 'qualAttr': 'ptpMode' }
   timestampFeatureEnabled = { 'entity': timestampFeatureStatus,
                               'qualAttr': 'enabled' }

   return ( anyPlls, [ anyDefaultPlls,
                       ptpEnabled,
                       timestampFeatureEnabled ] )

def getPermissiveRunnability( _context, pllName ):
   pllConfigPath = f'hardware/pllClockMux/config/{pllName}'
   anyPlls = { 'qualPath': f'{pllConfigPath}.pllCfg/%*' }
   anyDefaultPlls = { 'qualPath': f'{pllConfigPath}.defaultPll/%*' }
   return [ anyPlls, anyDefaultPlls ]

def _commonInit( context, pllName, agentName, runnabilityFunc ):
   systemAgentName = agentName
   systemAgentCfg = { 'name': systemAgentName,
                      'exe': f'/usr/bin/{agentName}',
                      'argv': [],
                      'heartbeatPeriod': 30,
                      'runnability': runnabilityFunc( context, pllName ) }
   role = { 'rpr': context.activeSupervisorRoleName,
            'sso': context.allSupervisorsRoleName }
   context.agentConfigIs( role, systemAgentCfg )

def commonInit( context, pllName, agentName ):
   '''
   This is a generic function which tells launcher to start an agent with name
   agentName if the pll configuration satisifies:
   1) some pll configuration exists
   2) a pll is configured to be used e.g. as defaultPll, ptp or otherwise
   '''
   _commonInit( context, pllName, agentName, getRunnability )

def commonPermissiveInit( context, pllName, agentName ):
   '''
   This is a generic function which tells launcher to start an agent with name
   agentName if the pll configuration satisifies:
   1) some pll configuration exists
   Used where we want the agent to start before any feature is configured
   '''
   _commonInit( context, pllName, agentName, getPermissiveRunnability )
