#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # -------------------------------------------------------------------------
   # Ebra runs on the "Supervisor" (whichever cell(s) that actually
   # corresponds to (c.f. AID158)), if there is at least one Ethernet
   # interface.
   #
   # For example, in a fixed-config box, the "Supervisor" runs on the
   # one-and-only cell, while in a modular chassis, it might run on
   # the cells corresponding to both supervisors.
   #
   # Ebra runs "if there is at least one Ethernet interface", i.e.,
   # there is at least one EthIntfStatus -- hence, the "entity" points
   # at "interface/status/eth/intf", and "qualAttr" is "intfStatus",
   # the name of the collection that contains the EthIntfStatuses.
   #
   # This might actually belong into a product-specific Launcher plugin,
   # e.g., into a Launcher plugin provided by the Aros package.
   # -------------------------------------------------------------------------

   agentName = "Ebra"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Ebra",
                "argv": [],
                "oomScoreAdj" : -400, #  see AID3426
                "heartbeatPeriod": 30 }
   roleName = { 'rpr' : context.activeSupervisorRoleName,
                'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )
