#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   eoamHwStatus = context.lookup( "eoam/hardware/status/global" )
   eoamConfig = context.lookup( "eoam/config" )

   reflectorConfig = context.lookup( "reflector/cliConfig" )
   reflectorHwCapabilities = context.lookup( "reflector/hardware/capabilities" )

   profileConfig = context.lookup( "sat/profile/cliConfig" )
   generatorHwCapabilities = context.lookup( "sat/hardware/capabilities" )

   rfc2544ProfileConfig = context.lookup( "rfc2544Initiator/profileConfigDir" )
   rfc2544HwCapabilities = context.lookup( "rfc2544Initiator/hardware/capabilities" )
   rfc2544FlowConfig = context.lookup( "generator/flowConfigDir/rfc2544" )

   gNOIRequest = context.lookup( "sat/intf/gNOIRequest" )

   fabricMeshConfig = context.lookup( "generator/fabricMesh/config" )

   # Agent runs only if one or more of the following are true:
   # - Eoam is supported and an eoam config exists
   # - Reflector is supported and an interface config exists
   # - LinkQual OpenConfig GNOI request exists and Reflector is supported
   # - LinkQual OpenConfig GNOI request made once and Reflector is supported
   # - LinkQual feature is supported and there is LinkQual profile config
   # - RFC2544 is supported and there is either a RFC2544 profile or flow config.
   # NOTE: The changes to this plugin are covered in an stest.
   rfc2544Runnability = ( { "entity" : rfc2544HwCapabilities,
                            "qualAttr" : "rfc2544InitiatorSupported" },
                          [ { "entity" : rfc2544ProfileConfig,
                              "qualAttr" : "profileConfig" },
                            { "entity" : rfc2544FlowConfig,
                              "qualAttr": "flowConfig" } ] )
   runnability = [ ( { "entity" : eoamHwStatus,
                       "qualAttr" : "eoamSupported" },
                     { "entity" : eoamConfig,
                       "qualAttr" : "eoamProfile" } ),
                   ( { "entity": reflectorHwCapabilities,
                       "qualAttr": "reflectorSupported" },
                     { "entity": reflectorHwCapabilities,
                       "qualAttr": "directionSupported" },
                     [
                       { "entity": reflectorConfig,
                         "qualAttr" : "interfaceConfig" },
                       { "entity": gNOIRequest,
                         "qualAttr" : "request" },
                       { "entity": gNOIRequest,
                         "qualAttr" : "keepAgentUp" }
                     ] ),
                   ( { "entity": generatorHwCapabilities,
                       "qualAttr": "hwCapable" },
                     { "entity": profileConfig,
                       "qualAttr" : "txConfig" } ),
                    rfc2544Runnability,
                    { "entity": fabricMeshConfig,
                      "qualAttr": "fabricMeshEnabled" } ]

   agentCfg = { "name": "Eoam",
                "exe": "/usr/bin/Eoam",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability" : runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
