# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
import Cell
import Toggles.StageMgrToggleLib
import Swag

# pkgdeps: rpm RedSup-lib

def Plugin( context ):
   # In swag, run unconditionally
   runnability = []
   if not Swag.swagMode():
      # Not in a swag, require the SSO toggle as well as being on a modular
      if not Toggles.StageMgrToggleLib.toggleSmashSSOEnabled():
         return
      runnabilityCfg = context.lookup( 'redundancy/election/runnability' )
      runnabilityAttr = 'modular' if( Cell.cellType() == 'supervisor' and
                                    Cell.electionMgrSupported() ) else 'fixed'
      runnability = [ { 'entity': runnabilityCfg,
                        'qualAttr': runnabilityAttr } ]


   agentCfg = {
     "name": "Espresso",
     "exe": "/usr/bin/Espresso",
     "argv": [ "--smid=%(smid)s" ],
     "heartbeatPeriod": 30,
     "runnability": runnability,
     "swagRunnabilityFilter": context.allSwagMembers
   }
   role = context.allSupervisorsRoleName
   context.agentConfigIs( role, agentCfg )
