#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'eventMon/config' )
   agentName = 'EventMon'
   agentCfg = {    'name' : agentName,
                   'exe' : '/usr/bin/EventMon',
                   'argv' : [],
                   'heartbeatPeriod' : 300,
                   'runnability': [ 
                      { 'entity': config, 'qualAttr': 'agentEnabled' },
                      { 'entity': config, 'qualAttr': 'agentEnabledOverride' },
                      ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
