#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   externalAlarmCliConfig = context.lookup( 'hardware/externalAlarm/cliConfig' )
   externalAlarmStatus = context.lookup( 'hardware/externalAlarm/status' )

   agentName = 'ExternalAlarm'
   runnability = [ { 'entity' : externalAlarmCliConfig,
                     'qualAttr' : 'alarm' },
                   { 'entity' : externalAlarmStatus,
                     'qualAttr' : 'alarm' } ]
   agentConfig = { 'name' : agentName,
                   'exe' : '/usr/bin/ExternalAlarm',
                   'argv' : [],
                   'heartbeatPeriod' : 30,
                   'runnability' : runnability }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentConfig )
