# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   extensionStatus = "cell/%cellId/sys/extension/status"
   flowWatcherConfig = context.lookup( "flowwatcher/config" )
   fwLauncherPath = "cell/%cellId/flowwatcher/launcherConfig/FlowWatcher"
   capabilities = context.lookup( "hardware/flowwatcher/capabilities" )
   sftLauncherPath = 'flowtracking/activeAgent/sft'

   # FlowWatcher will run when
   # ( flowWatcherConfig.enabled==True AND NDRSensor.swix is installed AND
   #   capabilities.awakeSupported==True AND SampledFlowTracker is not running )
   # OR
   # launcherConfig/flowWatcher is present ( flowWatcherStatus.enabled=True )
   agentCfg = { "name": "FlowWatcher",
                "exe": "/usr/bin/FlowWatcher",
                "argv": [],
                "heartbeatPeriod": 30,
                "startupGracePeriod": 150,
                "oomScoreAdj": 100, # see AID3426
                "runnability": ( [ ( { "entity": flowWatcherConfig,
                                       "qualAttr": "enabled" },
                                     { "qualPath": extensionStatus +
                                       ".installedPrimaryPkg/NDRSensor" },
                                     { "qualPath": capabilities,
                                       "qualAttr": "awakeSupported" },
                                     { 'qualPath': sftLauncherPath, 'negate': True },
                                    ),
                                   { "qualPath": fwLauncherPath },
                                  ] )
              }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
