# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

gribiAgentName = "Gribi"
def Plugin( context ):
   gribiEntity = context.lookup( "mgmt/gribi/config" )
   gribiStatusEntity = context.lookup( "mgmt/gribi/status" )

   agentCfg = { "name": gribiAgentName,
                 "exe": "/usr/bin/Gribi",
                 "argv": [],
                 "runnability": [ { "entity": gribiEntity,
                                    "qualAttr": "enabled" },
                                  { "entity": gribiStatusEntity,
                                    "qualAttr": "enabled" } ],
                # to allow for slow clients see BUG931424
                 "heartbeatPeriod": 300,
                 "startupGracePeriod": 300 } # give time for dumptypes

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
