# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps: import LauncherContext
# pkgdeps: rpmwith %{_libdir}/preinit/Gribi

gribiRouteAgentName = "GribiRoute"
def Plugin( context ):
   gribiEntity = context.lookup( "mgmt/gribi/config" )
   gribiRouteStatusEntity = context.lookup( "routing/gribiRoute/status" )

   agentCfg = { "name": gribiRouteAgentName,
                 "exe": "/usr/bin/GribiRoute",
                 "argv": [],
                 "runnability": [ { "entity": gribiEntity,
                                    "qualAttr": "enabled" },
                                  { "entity": gribiRouteStatusEntity,
                                    "qualAttr": "agentEnabled" } ],
                 "heartbeatPeriod": 30 }

   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )
