#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( "hadooptracer/config" )
   status = context.lookup( "hadooptracer/status" )

   # HadoopTracer runs conditionally on the active supervisor.
   agentName = "HadoopTracer"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/HadoopTracer",
                "argv" : [],
                "heartbeatPeriod" : 45,
                "runnability" : [ { "entity" : config, "qualAttr" : "enabled" },
                                  { "entity" : status, "qualAttr" : "running" } ]

              }

   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
