# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   probeRespConfig = context.lookup( "icmp/probe/config" )
   errRespConfig = context.lookup( "icmp/errorResponder/config" )
   errRespStatus = context.lookup( "icmp/errorResponder/status" )

   runnabilityCondProbeResponder = {
         "entity": probeRespConfig,
         "qualAttr": "enabled"
   }

   # Check if error responder enabled on all VRFs globally.
   runnabilityCondErrResponderGlobal = {
         "entity": errRespConfig,
         "qualAttr": "enabled"
   }

   # Check if we have error responder configuration for at least one VRF.
   runnabilityCondErrResponderVrf = {
         "entity": errRespConfig,
         "qualAttr": "vrfConfig"
   }

   # Leaving IcmpResponder running until status is cleared.
   # This will ensure that any AclPlugin config is also cleared.
   # Stale AclPlugin config will l cause Acl agent to add bad iptables
   # state.
   # Note that we cannot use EbpfConfig as launcher qualAttr because
   # launcher doesn't support cell paths.
   dirtyCondErrResponder = {
         "entity": errRespStatus,
         "qualAttr": "afStatus"
   }

   agentCfg = { "name": "IcmpResponder",
                "exe": "/usr/bin/IcmpResponder",
                "argv": [],
                "heartbeatPeriod": 30,

                "runnability": [
                   runnabilityCondProbeResponder,
                   runnabilityCondErrResponderGlobal,
                   runnabilityCondErrResponderVrf,
                   dirtyCondErrResponder,
                ],
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
