# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   snmpConfig = context.lookup( 'snmp/config' )

   agentCfg = {
      'name': 'IfIndex',
      'exe': '/usr/bin/IfIndex',
      'argv': [],
      'heartbeatPeriod': 60,
      'runnability': [ {
         'entity': snmpConfig,
         'qualAttr': 'serviceEnabled',
         'negate': True,
      } ]
   }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
