#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   hostProxyConfig =  context.lookup( 'igmphostproxy/config/' )

   hostProxyConfigured = {
      'entity': hostProxyConfig,
      'qualAttr': 'intfConfig'
   }

   runnability = [ hostProxyConfigured ]

   agentCfg = { "name" : "IgmpHostProxy",
         "exe" : "/usr/bin/IgmpHostProxy",
         "argv" : [],
         "heartbeatPeriod" : 30,
         "oomScoreAdj" : -150, #  see AID3426
         "runnability": runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
