# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # Agent is runnable if either:
   #    ( cliConfig::active is True AND
   #      there is at least one interface configured in cliConfig::interface AND
   #      hardwareConfig::featureSupported is True AND
   #      DhcpRelay is not running AND
   #      DhcpSnooping is not running AND
   #      DhcpServer is not running ) OR
   #    ipLockingStatus::active is True OR
   #    ( DhcpRelay is running AND
   #      ( cliConfig::ipv6EnforcedEnabledActive is False AND
   #        cliConfig::ipv4LockedAddressEnforcementDisabled is True AND
   #        hardwareConfig::v4EnforcementDisabledSupported is True ) OR
   #      ( cliConfig::ipv4EnforcedEnabledActive is False AND
   #        cliConfig::ipv6LockedAddressEnforcementDisabled is True AND
   #        hardwareConfig::v6EnforcementDisabledSupported is True ) )
   # ipLockingStatus::active allows our agent to call destructors before
   # launcherPlugin destroys the agent. This flag is set to True upon
   # initialization of ipLockingRoot and is set to False when all SMs are done
   # cleaning up.
   arpInspectionStatus = context.lookup( "security/arpInspection/status" )
   ipsgConfig = context.lookup( "security/ipsg/config" )
   cliConfig = context.lookup( "iplocking/cliConfig" )
   hardwareConfig = context.lookup( "iplocking/hardware/config" )
   ipLockingStatus = context.lookup( "iplocking/ipLockingStatus" )
   dhcpRelayStatus = context.lookup( 'ip/helper/dhcprelay/status' )
   dhcpSnoopingStatus = context.lookup( 'bridging/dhcpsnooping/status' )
   dhcpSnooping6Status = context.lookup( 'bridging/dhcpsnooping/dhcp6Status' )
   dhcpServerVrfStatus = context.lookup( 'dhcpServer/vrf/status' )
   agentCfg = {
     "name": "IpLocking",
     "exe": "/usr/bin/IpLocking",
     "argv": [],
     "heartbeatPeriod": 30,
     "runnability": [ ( { "entity": cliConfig,
                          "qualAttr": "active" },
                        { "entity": hardwareConfig,
                          "qualAttr": "featureSupported" },
                        { "entity": arpInspectionStatus,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": ipsgConfig,
                          "qualAttr": "ipsgEnabledIntf",
                          "negate": True },
                        { "entity": dhcpRelayStatus,
                          "qualAttr": "runControl",
                          "negate": True },
                        { "entity": dhcpSnoopingStatus,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": dhcpSnooping6Status,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": dhcpServerVrfStatus,
                          "qualAttr": "ipv4ServerRunning",
                          "negate": True },
                        { "entity": dhcpServerVrfStatus,
                          "qualAttr": "ipv6ServerRunning",
                          "negate": True },
                      ),
                      { "entity": ipLockingStatus,
                        "qualAttr": "active" },
                      ( { "entity": cliConfig,
                          "qualAttr": "active" },
                        { "entity": hardwareConfig,
                          "qualAttr": "featureSupported" },
                        { "entity": arpInspectionStatus,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": ipsgConfig,
                          "qualAttr": "ipsgEnabledIntf",
                          "negate": True },
                        { "entity": dhcpSnoopingStatus,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": dhcpSnooping6Status,
                          "qualAttr": "enabled",
                          "negate": True },
                        { "entity": dhcpServerVrfStatus,
                          "qualAttr": "ipv4ServerRunning",
                          "negate": True },
                        { "entity": dhcpServerVrfStatus,
                          "qualAttr": "ipv6ServerRunning",
                          "negate": True },
                        { "entity": dhcpRelayStatus,
                          "qualAttr": "runControl" },
                        [ ( { "entity": cliConfig,
                              "qualAttr": "ipv4LockedAddressEnforcementDisabled" },
                            { "entity": hardwareConfig,
                              "qualAttr": "v4EnforcementDisabledSupported" },
                            { "entity": cliConfig,
                              "qualAttr": "ipv6EnforcedEnabledActive",
                              "negate": True }
                          ),
                          ( { "entity": cliConfig,
                              "qualAttr": "ipv6LockedAddressEnforcementDisabled" },
                            { "entity": cliConfig,
                              "qualAttr": "ipv4EnforcedEnabledActive",
                              "negate": True }
                          )
                        ]
                      )
                    ]
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
