#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps : import LauncherContext
from __future__ import absolute_import, division, print_function
from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # -------------------------------------------------------------------------
   # Isis runs unconditionally on rpr standby supervisor. In all other cases,
   # the runnability condition must be satisfied to run the agent.
   # -------------------------------------------------------------------------
   runnability = ( { "qualPath" :
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Isis" }, )

   # Register Main Isis ( BR )
   registerAgent( context, "Isis", runnability, [] )

   # Vrf Isis ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
      ( { "qualPath" : "cell/%cellId/routing/IsisVrfLaunchIndicator/%sliceId" }, )
   argv = ( "--z", "'client vrfname %(sliceId)s ns-name ns-%(sliceId)s'",
            "--sliceId=%(sliceId)s" )
   registerAgent( context, "Isis-vrf", vrfRunnability, argv,
                  exeName="/usr/bin/Isis-vrf" )
