#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LauncherPlugin.HttpService
# pkgdeps: import LauncherContext

def Plugin( context ):
   apiConfig = context.lookup( LauncherPlugin.HttpService.configPath( "JsonApi" ) )
   apiRunnability = [ { 'entity' : apiConfig,
                         'qualAttr' : 'enabled' } ]
   agentCfg = { "name" : "JsonApiApp",
                "exe" : "/usr/bin/JsonApiApp",
                "argv": [ "--ini", "/etc/uwsgi/JsonWsgiApp.ini" ],
                "heartbeatPeriod" : 30,
                'runnability' : [ ( apiRunnability, ) ] }
   context.agentConfigIs( context.activeSupervisorRoleName, agentCfg )
