#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing6/multicast/agentstatus' )
   bessAgentStatusCli = context.lookup( 'bess/agentstatus/cli' )
   bessAgentStatusSfe = context.lookup( 'bess/agentstatus/sfe' )

   runnability = ( { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'multicastEnabled' },
                   { 'entity': bessAgentStatusCli,
                     'qualAttr': 'v6Enabled',
                     'negate': True },
                   { 'entity': bessAgentStatusSfe,
                     'qualAttr' : 'v6Enabled',
                     'negate' : True } )
   agentCfg = { "name": "KernelMfib6",
                "exe": "/usr/bin/KernelMfib6",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -400, #  see AID3426
                "runnability" : runnability }

   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )
