#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # The LacpTxAgent agent runs unconditionally right now.

   agentName = 'LacpTxAgent'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/LacpTxAgent',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'oomScoreAdj' : -350, #  see AID3426
                'latencySensitive' : True }
   roleName = { 'rpr' : context.activeSupervisorRoleName,
                'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( roleName, agentCfg )
