#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # only run on active
   roleName = context.activeSupervisorRoleName
   systemStatus = context.lookup( "sys/status/system" )

   agentName = "SystemInitMonitor"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/SystemInitMonitor",
                "argv": [],
                "heartbeatPeriod": 30,
                # We only need to run if system isn't yet initialized
                "runnability": [ { 'entity': systemStatus,
                                   'qualAttr': 'initialized',
                                   'negate': True } ]
               }
   context.agentConfigIs( roleName, agentCfg )
