#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( "bridging/linux/config" )

   agentName = "LinuxBridge"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/LinuxBridge",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability": [ { "entity": config,
                                   "qualAttr": "enabled" } ]

              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
