#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
from Toggles.LldpTogglesToggleLib import toggleLldpTerminateAgentEnabled

def Plugin( context ):

   # Lldp runs on both supervisors.
   agentName = "Lldp"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Lldp",
                "argv": [],
                "heartbeatPeriod": 30 }

   if toggleLldpTerminateAgentEnabled():
      lldpCliConfig = context.lookup( "l2discovery/lldp/cliConfig" )
      identityCliConfig = context.lookup( 'identity/nbrClassification/cliConfig' )
      identityStatus = context.lookup( 'identity/nbrClassification/status' )
      runnability = [
         { "entity" : lldpCliConfig, "qualAttr" : "enabled" },
         { "entity" : identityCliConfig, "qualAttr" : "neighbor" },
         { "entity" : identityStatus, "qualAttr" : "neighbor" },
      ]
      agentCfg[ "runnability" ] = runnability

   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )
