#!/usr/bin/env python3

# Copyright (c) 2024 Arista Networks, Inc. All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

from Toggles.LogArchiverToggleLib import toggleCronToAgentEnabled

def Plugin( context ):
   if not toggleCronToAgentEnabled():
      return
   agentName = 'LogArchiverAgent'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/LogArchiverAgent.py',
                'argv' : [],
                'heartbeatPeriod' : 30 }
   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )
