#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
import EosVersion

def Plugin( context ):
   config = context.lookup( "macsec/input/cli" )
   dmfConfig = context.lookup( "macsec/input/dmf" )
   status = context.lookup( "macsec/status" )
   mkaStatus = context.lookup( "macsec/mkaStatus" )
   runnability = [ { "entity" : config, "qualAttr" : "profile" },
                   { "entity" : dmfConfig, "qualAttr" : "profile" },
                   { "entity" : config, "qualAttr" : "licenseConfig" },
                   { "entity" : status, "qualAttr" : "intfStatus" },
                   { "entity" : status, "qualAttr" : "cpStatus" },
                   { "entity" : status, "qualAttr" : "licenseEnabled" },
                   { "entity" : mkaStatus, "qualAttr" : "portStatus" } ]

   agentCfg = { "name": "Macsec",
                "exe": "/usr/bin/Macsec",
                "argv": [ ],
                "heartbeatPeriod": 30,
                "runnability" : runnability }

   if EosVersion.VersionInfo( None ).isDPEVersion():
      del agentCfg [ "runnability" ]

   # run in all supervisor to support SSO
   roleName = { 'rpr': context.activeSupervisorRoleName,
                'sso': context.allSupervisorsRoleName }

   context.agentConfigIs( roleName, agentCfg )
