#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps : import LauncherContext

from LauncherPlugin.Maintenance import getMmodeRunnability

def Plugin( context ):
   # Don't run MaintenanceMode on SSO-standby, as maintenancemode/ready
   # qualPath is synced between active and standby( because qualPath is not
   # cell based ).
   # Run MaintenanceMode on RPR-standby to set maintenancemode/ready
   # qualPath as Rib/ArBgp is always runnable on RPR standby too. No sysdb sync
   # happen in case of RPR as is the case with SSO.
   roleName = { 'rpr' : context.allSupervisorsRoleName,
                'sso' : context.activeSupervisorRoleName }

   agentName = 'MaintenanceMode'
   exeName = '/usr/bin/MaintenanceMode'
   runnability = getMmodeRunnability()
   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }
   context.agentConfigIs( roleName, agentCfg )
