#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import Tac

# pkgdeps: import LauncherContext

def Plugin( context ):
   # Configure the ManagementActive agent to run on all
   # supervisors once the redundancy state is configured by RedSup's
   # plugin in modular dut.
   #
   # This is achieved by using the qualPath support in Launcher,
   # looking for 'status' in the redundancy/election/cellId directory.
   #
   # The ManagementActive agent is also started in the case of CVX VIP if the
   # defaultClusterStatus is enabled. The agent will run on both the master and
   # the slave nodes but the macvlan 0 kernel interfce will only be created on the
   # master node.

   constants = Tac.Type( "Controller::Constants" )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/" + constants.clusterDefaultName )

   runnability = None
   roleName = None
   agentName = 'ManagementActive'

   if Cell.cellType() == 'supervisor':
      runnability = [ { 'qualPath' : 'cell/%cellId/redundancy/election/status' } ]

      roleName = context.allSupervisorsRoleName
   else:
      runnability = [ { 'entity' : defaultClusterStatus,
                        'qualAttr' : 'enabled' } ]

      roleName = context.allSupervisorsRoleName

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/ManagementActive',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability' : runnability }

   context.agentConfigIs( roleName, agentCfg )
