# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   config = context.lookup( 'mdns/config' )
   status = context.lookup( 'mdns/status' )

   roleName = context.activeSupervisorRoleName
   agentName = "McastDns"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/McastDns",
                "argv": [],
                "heartbeatPeriod": 60,
                "runnability": [ { "entity": config,
                                    "qualAttr": "enabled" },
                                  { "entity": status,
                                    "qualAttr": "running" } ] }

   context.agentConfigIs( roleName, agentCfg )
