# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

agentName = "McastVpn"


def Plugin( context ):

   AddressFamily = Tac.Type( "Arnet::AddressFamily" )
   vxlanVtiStatus = context.lookup( 'interface/status/eth/vxlan' )
   AgentStatus = Tac.Type( "McastCommon::AgentStatus" )
   mcastStatusV4 = context.lookup( AgentStatus.mountPath( AddressFamily.ipv4 ) )
   mcastStatusV6 = context.lookup( AgentStatus.mountPath( AddressFamily.ipv6 ) )

   # Multicast v4/v6 enabled checks
   mcastV4Enabled = ( { 'entity': vxlanVtiStatus, 'qualAttr': 'vtiStatus' },
                      { 'entity': mcastStatusV4, 'qualAttr': 'multicastEnabled' } )
   mcastV6Enabled = ( { 'entity': vxlanVtiStatus, 'qualAttr': 'vtiStatus' },
                      { 'entity': mcastStatusV6, 'qualAttr': 'multicastEnabled' } )

   # McastVpn agent runnStatus check
   AgentRunningStatus = Tac.Type( "McastCommon::AgentRunningStatus" )
   agentRunningStatusMountPath = AgentRunningStatus.mountPath(
      AddressFamily.ipunknown, agentName )
   agentRunningStatus = context.lookup( agentRunningStatusMountPath )
   mcastVpnAgentRunning = { 'entity': agentRunningStatus, 'qualAttr': 'running' }

   runnability = [ mcastV4Enabled, mcastV6Enabled, mcastVpnAgentRunning ]
   agentCfg = {
      "name": agentName,
      "exe": "/usr/bin/McastVpn",
      "argv": [],
      "heartbeatPeriod": 30,
      "runnability": runnability
   }

   role = { 'rpr': context.activeSupervisorRoleName,
            'sso': context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )
