#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing6/multicast/agentstatus' )

   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'gmpEnabled' }, ]

   agentCfg = { "name": "Mld",
                "exe": "/usr/bin/Mld",
                "argv": [ ],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -300, #  see AID3426
                "runnability": runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

