# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   bridgingCapabilities = context.lookup( 'bridging/hwcapabilities' )
   mldconfig = context.lookup( 'bridging/mldsnooping/config' )
   mldrunnablepath = 'bridging/mldsnooping/runnability/status/enabled'

   # This will be "mldSnoopingSupported" at some point
   runnability = [
                    (
                       { 'entity': bridgingCapabilities,
                         'qualAttr': 'mldSnoopingSupported'
                       },
                       { 'entity': mldconfig,
                         'qualAttr': 'vlanDefaultEnabled'
                       },
                    ),
                    { 'qualPath': mldrunnablepath },
                 ]

   agentCfg = { "name": "MldSnooping",
                "exe": "/usr/bin/MldSnooping",
                "argv": [ ],
                "heartbeatPeriod": 30,
                "oomScoreAdj": -300, # see AID3426
                "runnability": runnability }

   role = { 'rpr': context.activeSupervisorRoleName,
            'sso': context.allSupervisorsRoleName }

   context.agentConfigIs( role, agentCfg )
