#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

msrpConfigPath = 'msrp/config'

# pkgdeps: import LauncherContext

def Plugin( context ):
   msrpConfig = context.lookup( msrpConfigPath )
   msrpStatus = context.lookup( "msrp/status" )

   agentName = 'Msrp'
   exeName = '/usr/bin/Msrp'
   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod" : 90,
                "runnability": [ { "entity" : msrpConfig,
                                   "qualAttr" : "intfEnable" },
                                 { "entity" : msrpStatus,
                                   "qualAttr" : "msrpEnabled" } ] }
   roleName = { 'sso' : context.allSupervisorsRoleName,
                'rpr' : context.activeSupervisorRoleName }

   context.agentConfigIs( roleName, agentCfg )
