#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mssAgentConfig = context.lookup( "mss/config" )
   controllerdbStatus = context.lookup( "controller/status" )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )
   mssL3AgentStatus = context.lookup( "mssl3/status" )

   agentName = "MssL3"
   agentConfig = { "name" : agentName,
                   "exe"  : "/usr/bin/MssL3",
                   "argv" : [],
                   "heartbeatPeriod": 120,

                   # Runnability for MssL3 is
                   # ( mssConfigEnabled && controllerdbStatusEnabled &&
                   #      standaloneOrLeader ) ||
                   # ( mssL3StatusRunning )
                   # That is:
                   #  If
                   #    Mss is enabled,
                   #      and CVX is enabled
                   #      and CVX is either standalone or a leader
                   #   OR
                   #    MssL3 still has unfinished business to take care of
                   "runnability" : [ ( { "entity" : mssAgentConfig,
                                         "qualAttr" : "enable" },
                                       { "entity" : controllerdbStatus,
                                         "qualAttr" : "enabled" },
                                       { "entity" : defaultClusterStatus,
                                         "qualAttr" : "isStandaloneOrLeader" }
                                     ),
                                     { "entity" : mssL3AgentStatus,
                                       "qualAttr" : "running" }
                                   ]
                 }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentConfig )
