#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
from Toggles.MvrpToggleLib import toggleDot1xMvrpVsaEnabled 
mvrpConfigInputPath = 'mvrp/input/config'

def getRunnability( context ):
   configSources = [ "cli" ]
   if toggleDot1xMvrpVsaEnabled():
      configSources.append( "dot1x" )
   runnability = []
   for source in configSources:
      qualEntity = context.lookup( mvrpConfigInputPath + '/' + source )
      runnability.append( { "entity" : qualEntity,
                            "qualAttr" : "intfEnable" } )
   mvrpStatus = context.lookup( "mvrp/status" )
   runnability.append( { "entity" : mvrpStatus,
                         "qualAttr" : "mvrpEnabled" } )
   return runnability

def Plugin( context ):
   agentName = 'Mvrp'
   exeName = '/usr/bin/Mvrp'
   runnability = getRunnability( context )
   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod" : 30,
                "runnability": runnability }
   roleName = { 'sso' : context.allSupervisorsRoleName,
                'rpr' : context.activeSupervisorRoleName }

   context.agentConfigIs( roleName, agentCfg )
