#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mgmtControllerConfig = context.lookup( 'mgmt/controller/config' )

   agentName = "NetworkTopology"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/NetworkTopology",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": [ { 'entity' : mgmtControllerConfig,
                   'qualAttr' : 'enabled' } ]
                }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

