#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = "ObjectTracking"

   trackingConfig = context.lookup( "tracking/config" )
   trackingStatus = context.lookup( "tracking/status" )

   agentCfg = { "name": agentName,
                "exe": "/usr/bin/ObjectTracking",
                "argv": [],
                "heartbeatPeriod" : 30,
                "runnability": [ { "entity" : trackingConfig,
                                   "qualAttr" : "interfaceObjectConfig" },
                                 { "entity" : trackingStatus,
                                   "qualAttr" : "trackedObjectStatus" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
