#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   twampConfig = context.lookup( 'perfsonartwamp/config' )
   agentName = "PerfsonarTwamp"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/PerfsonarTwamp",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": [ { "entity": twampConfig,
                                   "qualAttr": "server" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
