#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mfibHwStatus = context.lookup( "routing/hardware/multicast/status" )

   runnability = [ ( { 'qualPath':
                     "cell/%cellId/routing/multicast/agent/runnability/PimBidir" },
                   { 'entity': mfibHwStatus, 'qualAttr': 'maxRpas' }, )
                  ]

   agentCfg = { "name": "PimBidirDf",
                "exe": "/usr/bin/PimBidirDf",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -50, #  see AID3426
                "runnability" : runnability }

   role = { 'rpr' :  context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }

   context.agentConfigIs( role, agentCfg )
